<script>
    $(document).ready(function(){
        get_clients();
    });

    function get_clients()
    {
        $.ajax({
            url:'data/client',
            type:'get',
            contentType:false,
            processData:false,
            success:function(data)
            {
                $('#row').html(data['html']);
                $('#data').DataTable({
                    "responsive": true,
                    "lengthMenu": [5, 15, 20],
                    "pageLength": 5,
                    "autoWidth":true,
                });
            }
        });
    }

    function banStatus(id,status)
    {
        Swal.fire({
            icon:'warning',
            title:'Are you sure you want to change '+id+' status?',
            text:'Make sure you picked the right account',
            showCancelButton:true,
            cancelButtonColor:'#FFA81B',
            confirmButtonColor:'#0067FF',
            confirmButtonText:'Yes, update '+id+' status',
            width:400
        }).then((result) => {
            if(result.value)
            {
                $.ajax({
                    url:'misc/client/statusChange/?id='+id+'&status='+status,
                    type:'get',
                    contentType:false,
                    processData:false,
                    success:function(data)
                    {
                        if(data['status'] == 'success')
                        {
                            Swal.fire({
                                icon:data['status'],
                                title:data['warning'],
                                text:data['message'],
                                confirmButtonColor:'#0067FF',
                                width:400
                            }).then((result) => {
                                if(result.value)
                                {
                                    get_clients();
                                }
                            });
                        }

                        if(data['status'] == 'warning')
                        {
                            Swal.fire({
                                icon:data['status'],
                                title:data['warning'],
                                text:data['message'],
                                confirmButtonColor:'#0067FF',
                                width:400
                            }).then((result) => {
                                if(result.value)
                                {
                                    get_service();
                                }
                            });
                        }

                        if(data['status'] == 'error')
                        {
                            Swal.fire({
                                icon:data['status'],
                                title:data['warning'],
                                text:data['message'],
                                confirmButtonColor:'#0067FF',
                                width:400
                            }).then((result) => {
                                if(result.value)
                                {
                                    get_clients();
                                }
                            });
                        }
                    }
                });
            }
        });
    }

    $(document).on('submit','#add',function(e){
        e.preventDefault();

        Swal.fire({
            icon:'warning',
            title:'Are you sure you want to save this data?',
            text:'Check again if something missing',
            showCancelButton:true,
            cancelButtonColor:'#FFA81B',
            confirmButtonColor:'#0067FF',
            confirmButtonText:'Yes, Save Data',
            width:400
        }).then((result) => {
            if(result.value)
            {
                $('#addBtn').html('<i class="fas fa-cog fa-spin"></i> Saving');
                $('#addBtn').attr('disabled',true);

                $.ajax({
                    url:'misc/client/add',
                    type:'post',
                    data: new FormData(this),
                    contentType:false,
                    processData:false,
                    success:function(data)
                    {
                        if(data['status'] == 'success')
                        {
                            Swal.fire({
                                icon:data['status'],
                                title:data['warning'],
                                text:data['message'],
                                confirmButtonColor:'#0067FF',
                                width:400
                            }).then((result) => {
                                if(result.value)
                                {
                                    $('#modal').modal('hide');
                                    get_clients();
                                }
                            });
                        }

                        if(data['status'] == 'warning')
                        {
                            Swal.fire({
                                icon:data['status'],
                                title:data['warning'],
                                text:data['message'],
                                confirmButtonColor:'#0067FF',
                                width:400
                            }).then((result) => {
                                if(result.value)
                                {
                                    $('#addBtn').html('<i class="fas fa-check"></i> Save');
                                    $('#addBtn').attr('disabled',false);
                                }
                            });
                        }

                        if(data['status'] == 'error')
                        {
                            Swal.fire({
                                icon:data['status'],
                                title:data['warning'],
                                text:data['message'],
                                confirmButtonColor:'#0067FF',
                                width:400
                            }).then((result) => {
                                if(result.value)
                                {
                                    $('#addBtn').html('<i class="fas fa-check"></i> Save');
                                    $('#addBtn').attr('disabled',false);
                                }
                            });
                        }
                    }
                });
            }
        });
    });

    $(document).on('submit','#edit',function(e){
        e.preventDefault();

        Swal.fire({
            icon:'warning',
            title:'Are you sure you want to save this data?',
            text:'Check again if something missing',
            showCancelButton:true,
            cancelButtonColor:'#FFA81B',
            confirmButtonColor:'#0067FF',
            confirmButtonText:'Yes, Save Data',
            width:400
        }).then((result) => {
            if(result.value)
            {
                $('#editBtn').html('<i class="fas fa-cog fa-spin"></i> Updating');
                $('#editBtn').attr('disabled',true);

                $.ajax({
                    url:'misc/client/edit',
                    type:'post',
                    data: new FormData(this),
                    contentType:false,
                    processData:false,
                    success:function(data)
                    {
                        if(data['status'] == 'success')
                        {
                            Swal.fire({
                                icon:data['status'],
                                title:data['warning'],
                                text:data['message'],
                                confirmButtonColor:'#0067FF',
                                width:400
                            }).then((result) => {
                                if(result.value)
                                {
                                    $('#modal').modal('hide');
                                    get_clients();
                                }
                            });
                        }

                        if(data['status'] == 'warning')
                        {
                            Swal.fire({
                                icon:data['status'],
                                title:data['warning'],
                                text:data['message'],
                                confirmButtonColor:'#0067FF',
                                width:400
                            }).then((result) => {
                                if(result.value)
                                {
                                    $('#editBtn').html('<i class="fas fa-edit"></i> Update');
                                    $('#editBtn').attr('disabled',false);
                                }
                            });
                        }

                        if(data['status'] == 'error')
                        {
                            Swal.fire({
                                icon:data['status'],
                                title:data['warning'],
                                text:data['message'],
                                confirmButtonColor:'#0067FF',
                                width:400
                            }).then((result) => {
                                if(result.value)
                                {
                                    $('#editBtn').html('<i class="fas fa-edit"></i> Update');
                                    $('#editBtn').attr('disabled',false);
                                }
                            });
                        }
                    }
                });
            }
        });
    });

</script>
<?php /**PATH C:\xampp\htdocs\company_profile_backend\resources\views/customs/client-js.blade.php ENDPATH**/ ?>