<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Auth
Route::get('/', 'Auth@index');

// Authentication
Route::post('/login','Auth@login');
Route::get('/logout','Auth@logout');

// Panel
// Dashboard
Route::get('/dashboard','Panel@dashboard');
// Master-data
// Admin
Route::get('/admin-data','Panel@admins');
// About
Route::get('/about','Panel@about');
Route::get('/edit_about','Panel@edit_about');
// News
Route::get('/news','Panel@news');
Route::get('/add_news','Panel@add_news');
Route::get('/edit_news','Panel@edit_news');
// Loker
Route::get('/loker','Panel@loker');
Route::get('/add_loker','Panel@add_loker');
Route::get('/edit_loker','Panel@edit_loker');
// Service
Route::get('/service','Panel@service');
Route::get('/add_service','Panel@add_service');
Route::get('/edit_service','Panel@edit_service');
// Clients
Route::get('/clients','Panel@clients');


// Data
Route::group(['prefix' => 'data'], function () {
    // Admin
    Route::get('/admins','Data\Admin@index');
    // News
    Route::get('/news','Data\News@index');
    // Loker
    Route::get('/loker','Data\Loker@index');
    // Service
    Route::get('/service','Data\Service@index');
    // Client
    Route::get('/client','Data\Clients@index');
});

// Modal
Route::group(['prefix' => 'modal'], function () {
    // Admin
    Route::group(['prefix' => 'admin'], function () {
        Route::get('/add','Modal\Admin@add');
        Route::get('/edit','Modal\Admin@edit');
    });
    // Client
    Route::group(['prefix' => 'client'], function () {
        Route::get('/add','Modal\Client@add');
        Route::get('/edit','Modal\Client@edit');
    });
});

// Misc
Route::group(['prefix' => 'misc'], function () {
    // Admin
    Route::group(['prefix' => 'admin'], function () {
        Route::post('/add','Misc\Admin@add');
        Route::post('/edit','Misc\Admin@edit');
        Route::get('/ban_status','Misc\Admin@ban_status');
    });
    // About
    Route::group(['prefix' => 'about'], function () {
        Route::post('/edit','Misc\About@edit');
    });
    // News
    Route::group(['prefix' => 'news'], function () {
        Route::post('/add','Misc\News@add');
        Route::post('/edit','Misc\News@edit');
        Route::get('/statusChange','Misc\News@statusChange');
    });
    // Loker
    Route::group(['prefix' => 'loker'], function () {
        Route::post('/add','Misc\Loker@add');
        Route::post('/edit','Misc\Loker@edit');
        Route::get('/statusChange','Misc\Loker@statusChange');
    });
    // Service
    Route::group(['prefix' => 'service'], function () {
        Route::post('/add','Misc\Service@add');
        Route::post('/edit','Misc\Service@edit');
        Route::get('/statusChange','Misc\Service@statusChange');
    });
    // Client
    Route::group(['prefix' => 'client'], function () {
        Route::post('/add','Misc\Client@add');
        Route::post('/edit','Misc\Client@edit');
        Route::get('/statusChange','Misc\Client@statusChange');
    });
});
