@extends('layouts.app')

@section('title',$title)

@section('content')

    <div class="page-wrapper">
        @include('layouts.header-mobile')
        @include('layouts.sidebar')
        <div class="page-container">
            @include('layouts.header')

            <div class="main-content">
                <div class="section__content section__content--p-30">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-lg-11">
                                <div class="card">
                                    <div class="card-header">
                                        <h1>{{$title}}</h1>
                                    </div>
                                    <div class="card-body">
                                        <a href="service" class="btn btn-success mb-5">
                                            <i class="fas fa-chevron-left"></i> Go Back
                                        </a>
                                        <form method="post" enctype="multipart/form-data" id="edit">
                                            @csrf
                                            <input type="hidden" name="service_id" value="{{$service['service_id']}}">
                                            <div class="form-group">
                                                <label for="" class="col-md-4">Service Title</label>
                                                <input type="text" name="service_title" id="service_title" class="form-control col-md-6" placeholder="service Title" value="{{$service['service_title']}}"  onkeyup="generateURL()">
                                            </div>
                                            <div class="form-group">
                                                <label for="" class="col-md-4">Service Image</label>
                                                <img src="{{asset('storage/uploaded/service_image')}}/{{$service['service_image']}}" style="height: 150px; object-fit: cover;:" alt="">
                                                <input type="file" name="service_image" class="form-control col-md-6">
                                            </div>
                                            <div class="form-group">
                                                <label for="" class="col-md-4">Service Image Alt</label>
                                                <input type="text" name="service_image_alt" class="form-control col-md-6" placeholder="Image Alt" value="{{$service['service_image_alt']}}">
                                            </div>
                                            <div class="form-group">
                                                <label for="" class="col-md-4">Service Text</label>
                                                <textarea name="service_text" cols="30" rows="10" class="form-control col-md-6 desc">{{$service['service_text']}}</textarea>
                                            </div>
                                            <div class="form-group">
                                                <label for="" class="col-md-4">Service Url</label>
                                                <input type="text" name="service_url" id="service_url" class="form-control col-md-6" placeholder="URL" readonly value="{{$service['service_url']}}">
                                            </div>
                                            <div class="form-group">
                                                <label for="" class="col-md-4">Service Meta Description (SEO)</label>
                                                <input type="text" name="service_meta_description" class="form-control col-md-6" placeholder="Meta Description" value="{{$service['service_meta_description']}}">
                                            </div>
                                            <div class="form-group">
                                                <button type="submit" id="editBtn" class="btn btn-lg btn-primary mt-3">
                                                    <i class="fas fa-edit"></i> Update
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@push('styles')
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
@endpush

@push('scripts')
    @include('customs.custom-js')
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>
    @include('customs.service-js')
@endpush
