@extends('layouts.app')

@section('title',$title)

@section('content')

    <div class="page-wrapper">
        @include('layouts.header-mobile')
        @include('layouts.sidebar')
        <div class="page-container">
            @include('layouts.header')

            <div class="main-content">
                <div class="section__content section__content--p-30">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-lg-11">
                                <div class="card">
                                    <div class="card-header">
                                        <h1>{{$title}}</h1>
                                    </div>
                                    <div class="card-body">
                                        <a href="news" class="btn btn-success mb-5">
                                            <i class="fas fa-chevron-left"></i> Go Back
                                        </a>
                                        <form method="post" enctype="multipart/form-data" id="edit">
                                            @csrf
                                            <input type="hidden" name="news_id" value="{{$news['news_id']}}">
                                            <div class="form-group">
                                                <label for="" class="col-md-4">News Title</label>
                                                <input type="text" name="news_title" id="news_title" class="form-control col-md-6" placeholder="News Title" value="{{$news['news_title']}}"  onkeyup="generateURL()">
                                            </div>
                                            <div class="form-group">
                                                <label for="" class="col-md-4">News Image</label>
                                                <img src="{{asset('storage/uploaded/news_image')}}/{{$news['news_image']}}" style="height: 150px; object-fit: cover;:" alt="">
                                                <input type="file" name="news_image" class="form-control col-md-6">
                                            </div>
                                            <div class="form-group">
                                                <label for="" class="col-md-4">News Image Alt</label>
                                                <input type="text" name="news_image_alt" class="form-control col-md-6" placeholder="Image Alt" value="{{$news['news_image_alt']}}">
                                            </div>
                                            <div class="form-group">
                                                <label for="" class="col-md-4">News Text</label>
                                                <textarea name="news_text" cols="30" rows="10" class="form-control col-md-6 desc">{{$news['news_text']}}</textarea>
                                            </div>
                                            <div class="form-group">
                                                <label for="" class="col-md-4">News Url</label>
                                                <input type="text" name="news_url" id="news_url" class="form-control col-md-6" placeholder="URL" readonly value="{{$news['news_url']}}">
                                            </div>
                                            <div class="form-group">
                                                <label for="" class="col-md-4">News Meta Description (SEO)</label>
                                                <input type="text" name="news_meta_description" class="form-control col-md-6" placeholder="Meta Description" value="{{$news['news_meta_description']}}">
                                            </div>
                                            <div class="form-group">
                                                <button type="submit" id="editBtn" class="btn btn-lg btn-primary mt-3">
                                                    <i class="fas fa-edit"></i> Update
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@push('styles')
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
@endpush

@push('scripts')
    @include('customs.custom-js')
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>
    @include('customs.news-js')
@endpush
