@extends('layouts.app')

@section('title',$title)

@section('content')

    <div class="page-wrapper">
        @include('layouts.header-mobile')
        @include('layouts.sidebar')
        <div class="page-container">
            @include('layouts.header')

            <div class="main-content">
                <div class="section__content section__content--p-30">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-lg-11">
                                <div class="card">
                                    <div class="card-header">
                                        <h1>{{$title}}</h1>
                                    </div>
                                    <div class="card-body">
                                        <a href="about" class="btn btn-success mb-5">
                                            <i class="fas fa-chevron-left"></i> Go Back
                                        </a>
                                        <form method="post" enctype="multipart/form-data" id="edit">
                                            @csrf
                                            <input type="hidden" name="about_id" value="{{$about['about_id']}}">
                                            <div class="form-group">
                                                <label for="" class="col-md-4">Tentang Kami</label>
                                                <textarea name="about_desc_ina" id="" cols="30" rows="10" class="form-control desc">{{$about['about_desc_ina']}}</textarea>
                                            </div>
                                            <!-- <div class="form-group mb-3">
                                                <label for="" class="col-md-4">About (English)</label>
                                                <textarea name="about_desc_eng" id="" cols="30" rows="10" class="form-control desc">{{$about['about_desc_eng']}}</textarea> -->
                                            <!-- </div> -->
                                            <div class="form-group">
                                                <button type="submit" id="editBtn" class="btn btn-lg btn-primary">
                                                    <i class="fas fa-edit"></i> Update
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection


@push('styles')
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
@endpush

@push('scripts')
    @include('customs.custom-js')
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>
    @include('customs.about-js')
@endpush
