<script>
    $(document).ready(function(){
        window.onload = get_service();

        $('.desc').summernote({
                height: 300,
                dialogsInBody: true,
                dialogsFade: true,
                toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['font', ['strikethrough', 'superscript', 'subscript']],
                    ['fontsize', ['fontsize']],
                    ['fontname'],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['height', ['height']],
                    ['picture'],
                    ['link'],
                    ['video'],
                ]
            });
    });

    function generateURL()
    {
        var judul = $('#service_title').val();

        var kecil = judul.toLowerCase();

        var pisahin = kecil.split(" ");

        var url = pisahin.join("-");

        $('#service_url').val(url);
    }

    function get_service()
    {
        $.ajax({
            url:'data/service',
            type:'get',
            contentType:false,
            processData:false,
            success:function(data)
            {
                $('#row').html(data['html']);
                $('#data').DataTable({
                    "responsive": true,
                    "lengthMenu": [5, 15, 20],
                    "pageLength": 5,
                    "autoWidth":true,
                });
            }
        });
    }

    function banStatus(id,status)
    {
        Swal.fire({
            icon:'warning',
            title:'Are you sure you want to change '+id+' status?',
            text:'Make sure you picked the right account',
            showCancelButton:true,
            cancelButtonColor:'#FFA81B',
            confirmButtonColor:'#0067FF',
            confirmButtonText:'Yes, update '+id+' status',
            width:400
        }).then((result) => {
            if(result.value)
            {
                $.ajax({
                    url:'misc/service/statusChange/?id='+id+'&status='+status,
                    type:'get',
                    contentType:false,
                    processData:false,
                    success:function(data)
                    {
                        if(data['status'] == 'success')
                        {
                            Swal.fire({
                                icon:data['status'],
                                title:data['warning'],
                                text:data['message'],
                                confirmButtonColor:'#0067FF',
                                width:400
                            }).then((result) => {
                                if(result.value)
                                {
                                    get_service();
                                }
                            });
                        }

                        if(data['status'] == 'warning')
                        {
                            Swal.fire({
                                icon:data['status'],
                                title:data['warning'],
                                text:data['message'],
                                confirmButtonColor:'#0067FF',
                                width:400
                            }).then((result) => {
                                if(result.value)
                                {
                                    get_service();
                                }
                            });
                        }

                        if(data['status'] == 'error')
                        {
                            Swal.fire({
                                icon:data['status'],
                                title:data['warning'],
                                text:data['message'],
                                confirmButtonColor:'#0067FF',
                                width:400
                            }).then((result) => {
                                if(result.value)
                                {
                                    get_service();
                                }
                            });
                        }
                    }
                });
            }
        });
    }

    $(document).on('submit','#add',function(e){
        e.preventDefault();

        Swal.fire({
            icon:'warning',
            title:'Are you sure you want to save this data?',
            text:'Check again if something missing',
            showCancelButton:true,
            cancelButtonColor:'#FFA81B',
            confirmButtonColor:'#0067FF',
            confirmButtonText:'Yes, Save Data',
            width:400
        }).then((result) => {
            if(result.value)
            {
                $('#addBtn').html('<i class="fas fa-cog fa-spin"></i> Saving');
                $('#addBtn').attr('disabled',true);

                $.ajax({
                    url:'misc/service/add',
                    type:'post',
                    data: new FormData(this),
                    contentType:false,
                    processData:false,
                    success:function(data)
                    {
                        if(data['status'] == 'success')
                        {
                            Swal.fire({
                                icon:data['status'],
                                title:data['warning'],
                                text:data['message'],
                                confirmButtonColor:'#0067FF',
                                width:400
                            }).then((result) => {
                                if(result.value)
                                {
                                    window.location = "service";
                                }
                            });
                        }

                        if(data['status'] == 'warning')
                        {
                            Swal.fire({
                                icon:data['status'],
                                title:data['warning'],
                                text:data['message'],
                                confirmButtonColor:'#0067FF',
                                width:400
                            }).then((result) => {
                                if(result.value)
                                {
                                    $('#addBtn').html('<i class="fas fa-check"></i> Save');
                                    $('#addBtn').attr('disabled',false);
                                }
                            });
                        }

                        if(data['status'] == 'error')
                        {
                            Swal.fire({
                                icon:data['status'],
                                title:data['warning'],
                                text:data['message'],
                                confirmButtonColor:'#0067FF',
                                width:400
                            }).then((result) => {
                                if(result.value)
                                {
                                    $('#addBtn').html('<i class="fas fa-check"></i> Save');
                                    $('#addBtn').attr('disabled',false);
                                }
                            });
                        }
                    }
                });
            }
        });
    });

    $(document).on('submit','#edit',function(e){
        e.preventDefault();

        Swal.fire({
            icon:'warning',
            title:'Are you sure you want to save this data?',
            text:'Check again if something missing',
            showCancelButton:true,
            cancelButtonColor:'#FFA81B',
            confirmButtonColor:'#0067FF',
            confirmButtonText:'Yes, Save Data',
            width:400
        }).then((result) => {
            if(result.value)
            {
                $('#editBtn').html('<i class="fas fa-cog fa-spin"></i> Updating');
                $('#editBtn').attr('disabled',true);

                $.ajax({
                    url:'misc/service/edit',
                    type:'post',
                    data: new FormData(this),
                    contentType:false,
                    processData:false,
                    success:function(data)
                    {
                        if(data['status'] == 'success')
                        {
                            Swal.fire({
                                icon:data['status'],
                                title:data['warning'],
                                text:data['message'],
                                confirmButtonColor:'#0067FF',
                                width:400
                            }).then((result) => {
                                if(result.value)
                                {
                                    window.location = "service";
                                }
                            });
                        }

                        if(data['status'] == 'warning')
                        {
                            Swal.fire({
                                icon:data['status'],
                                title:data['warning'],
                                text:data['message'],
                                confirmButtonColor:'#0067FF',
                                width:400
                            }).then((result) => {
                                if(result.value)
                                {
                                    $('#editBtn').html('<i class="fas fa-edit"></i> Update');
                                    $('#editBtn').attr('disabled',false);
                                }
                            });
                        }

                        if(data['status'] == 'error')
                        {
                            Swal.fire({
                                icon:data['status'],
                                title:data['warning'],
                                text:data['message'],
                                confirmButtonColor:'#0067FF',
                                width:400
                            }).then((result) => {
                                if(result.value)
                                {
                                    $('#editBtn').html('<i class="fas fa-edit"></i> Update');
                                    $('#editBtn').attr('disabled',false);
                                }
                            });
                        }
                    }
                });
            }
        });
    });
</script>
