<script>
    $(document).ready(function(){
        window.onload = get_admin();
    });

    function get_admin()
    {
        $.ajax({
            url:'data/admins',
            type:'get',
            contentType:false,
            processData:false,
            success:function(data)
            {
                $('#row').html(data['html']);
                $('#data').DataTable({
                    "responsive": true,
                    "lengthMenu": [5, 15, 20],
                    "pageLength": 5,
                    "autoWidth":true,
                });
            }
        });
    }

    function banStatus(id,username,status)
    {
        Swal.fire({
            icon:'warning',
            title:'Are you sure you want to change '+username+' status?',
            text:'Make sure you picked the right account',
            showCancelButton:true,
            cancelButtonColor:'#FFA81B',
            confirmButtonColor:'#0067FF',
            confirmButtonText:'Yes, update '+username+' status',
            width:400
        }).then((result) => {
            if(result.value)
            {
                $.ajax({
                    url:'misc/admin/ban_status/?id='+id+'&status='+status,
                    type:'get',
                    contentType:false,
                    processData:false,
                    success:function(data)
                    {
                        if(data['status'] == 'success')
                        {
                            Swal.fire({
                                icon:data['status'],
                                title:data['warning'],
                                text:data['message'],
                                confirmButtonColor:'#0067FF',
                                width:400
                            }).then((result) => {
                                if(result.value)
                                {
                                    get_admin();
                                }
                            });
                        }

                        if(data['status'] == 'warning')
                        {
                            Swal.fire({
                                icon:data['status'],
                                title:data['warning'],
                                text:data['message'],
                                confirmButtonColor:'#0067FF',
                                width:400
                            }).then((result) => {
                                if(result.value)
                                {
                                    get_admin();
                                }
                            });
                        }

                        if(data['status'] == 'error')
                        {
                            Swal.fire({
                                icon:data['status'],
                                title:data['warning'],
                                text:data['message'],
                                confirmButtonColor:'#0067FF',
                                width:400
                            }).then((result) => {
                                if(result.value)
                                {
                                    get_admin();
                                }
                            });
                        }
                    }
                });
            }
        });
    }

    $(document).on('submit','#add',function(e){
        e.preventDefault();

        Swal.fire({
            icon:'warning',
            title:'Are you sure you want to save this data?',
            text:'Check again if something missing',
            showCancelButton:true,
            cancelButtonColor:'#FFA81B',
            confirmButtonColor:'#0067FF',
            confirmButtonText:'Yes, Save Data',
            width:400
        }).then((result) => {
            if(result.value)
            {
                $('#addBtn').html('<i class="fas fa-cog fa-spin"></i> Saving');
                $('#addBtn').attr('disabled',true);

                $.ajax({
                    url:'misc/admin/add',
                    type:'post',
                    data: new FormData(this),
                    contentType:false,
                    processData:false,
                    success:function(data)
                    {
                        if(data['status'] == 'success')
                        {
                            Swal.fire({
                                icon:data['status'],
                                title:data['warning'],
                                text:data['message'],
                                confirmButtonColor:'#0067FF',
                                width:400
                            }).then((result) => {
                                if(result.value)
                                {
                                    $('#modal').modal('hide');
                                    get_admin();
                                }
                            });
                        }

                        if(data['status'] == 'warning')
                        {
                            Swal.fire({
                                icon:data['status'],
                                title:data['warning'],
                                text:data['message'],
                                confirmButtonColor:'#0067FF',
                                width:400
                            }).then((result) => {
                                if(result.value)
                                {
                                    $('#addBtn').html('<i class="fas fa-check"></i> Save');
                                    $('#addBtn').attr('disabled',false);
                                }
                            });
                        }

                        if(data['status'] == 'error')
                        {
                            Swal.fire({
                                icon:data['status'],
                                title:data['warning'],
                                text:data['message'],
                                confirmButtonColor:'#0067FF',
                                width:400
                            }).then((result) => {
                                if(result.value)
                                {
                                    $('#addBtn').html('<i class="fas fa-check"></i> Save');
                                    $('#addBtn').attr('disabled',false);
                                }
                            });
                        }
                    }
                });
            }
        });
    });

    $(document).on('submit','#edit',function(e){
        e.preventDefault();

        Swal.fire({
            icon:'warning',
            title:'Are you sure you want to save this data?',
            text:'Check again if something missing',
            showCancelButton:true,
            cancelButtonColor:'#FFA81B',
            confirmButtonColor:'#0067FF',
            confirmButtonText:'Yes, Save Data',
            width:400
        }).then((result) => {
            if(result.value)
            {
                $('#editBtn').html('<i class="fas fa-cog fa-spin"></i> Updating');
                $('#editBtn').attr('disabled',true);

                $.ajax({
                    url:'misc/admin/edit',
                    type:'post',
                    data: new FormData(this),
                    contentType:false,
                    processData:false,
                    success:function(data)
                    {
                        if(data['status'] == 'success')
                        {
                            Swal.fire({
                                icon:data['status'],
                                title:data['warning'],
                                text:data['message'],
                                confirmButtonColor:'#0067FF',
                                width:400
                            }).then((result) => {
                                if(result.value)
                                {
                                    $('#modal').modal('hide');
                                    get_admin();
                                }
                            });
                        }

                        if(data['status'] == 'warning')
                        {
                            Swal.fire({
                                icon:data['status'],
                                title:data['warning'],
                                text:data['message'],
                                confirmButtonColor:'#0067FF',
                                width:400
                            }).then((result) => {
                                if(result.value)
                                {
                                    $('#editBtn').html('<i class="fas fa-edit"></i> Update');
                                    $('#editBtn').attr('disabled',false);
                                }
                            });
                        }

                        if(data['status'] == 'error')
                        {
                            Swal.fire({
                                icon:data['status'],
                                title:data['warning'],
                                text:data['message'],
                                confirmButtonColor:'#0067FF',
                                width:400
                            }).then((result) => {
                                if(result.value)
                                {
                                    $('#editBtn').html('<i class="fas fa-edit"></i> Update');
                                    $('#editBtn').attr('disabled',false);
                                }
                            });
                        }
                    }
                });
            }
        });
    });
</script>
