    <script>
        $(document).ready(function(){
            $('.desc').summernote({
                height: 300,
                dialogsInBody: true,
                dialogsFade: true,
                toolbar: [
                    // [groupName, [list of button]]
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['font', ['strikethrough', 'superscript', 'subscript']],
                    ['fontsize', ['fontsize']],
                    ['fontname'],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['height', ['height']],
                    ['picture'],
                    ['link'],
                    ['video'],
                ]
            });
        });

        $(document).on('submit','#edit',function(e){
            e.preventDefault();

            Swal.fire({
                icon:'warning',
                title:'Are you sure you want to save this data?',
                text:'Check again if something missing',
                showCancelButton:true,
                cancelButtonColor:'#FFA81B',
                confirmButtonColor:'#0067FF',
                confirmButtonText:'Yes, save data',
                width:400
            }).then((result) => {
                if(result.value)
                {
                    $('#editBtn').html('<i class="fas fa-cog fa-spin"></i> Updating');
                    $('#editBtn').attr('disabled',true);

                    $.ajax({
                        url:'misc/about/edit',
                        type:'post',
                        data: new FormData(this),
                        contentType:false,
                        processData:false,
                        success:function(data)
                        {
                            if(data['status'] == 'success')
                            {
                                Swal.fire({
                                    icon:data['status'],
                                    title:data['warning'],
                                    text:data['message'],
                                    confirmButtonColor:'#0067FF',
                                    width:400
                                }).then((result) => {
                                    if(result.value)
                                    {
                                        window.location = 'about';
                                    }
                                });
                            }

                            if(data['status'] == 'warning')
                            {
                                Swal.fire({
                                    icon:data['status'],
                                    title:data['warning'],
                                    text:data['message'],
                                    confirmButtonColor:'#0067FF',
                                    width:400
                                }).then((result) => {
                                    if(result.value)
                                    {
                                        $('#editBtn').html('<i class="fas fa-edit"></i> Update');
                                        $('#editBtn').attr('disabled',false);
                                    }
                                });
                            }

                            if(data['status'] == 'error')
                            {
                                Swal.fire({
                                    icon:data['status'],
                                    title:data['warning'],
                                    text:data['message'],
                                    confirmButtonColor:'#0067FF',
                                    width:400
                                }).then((result) => {
                                    if(result.value)
                                    {
                                        $('#editBtn').html('<i class="fas fa-edit"></i> Update');
                                        $('#editBtn').attr('disabled',false);
                                    }
                                });
                            }
                        }
                    });
                }
            });
        });
    </script>
