<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class Panel extends Controller
{
    public function dashboard()
    {
        if(session('is_login') != 1)
        {
            return redirect('');
        }

        return view('dashboard',[
            'title' => 'Dashboard',
            'menu' => 'dashboard',
            'sub_menu' => ''
        ]);
    }

    public function admins()
    {
        if(session('is_login') != 1)
        {
            return redirect('');
        }

        return view('master-data.admin',[
            'title' => 'Admin Data',
            'menu' => 'master-data',
            'sub_menu' => 'admin-data'
        ]);
    }

    public function about()
    {
        if(session('is_login') != 1)
        {
            return redirect('');
        }

        $get_about = std_get([
            'table_name' => 'about',
            'first_row' => true
        ]);

        return view('landing-page.about.view',[
            'title' => 'About',
            'menu' => 'landing-page',
            'sub_menu' => 'about',
            'about' => $get_about
        ]);
    }

    public function edit_about()
    {
        if(session('is_login') != 1)
        {
            return redirect('');
        }

        $get_about = std_get([
            'table_name' => 'about',
            'first_row' => true
        ]);

        return view('landing-page.about.edit',[
            'title' => 'Edit About',
            'menu' => 'landing-page',
            'sub_menu' => 'about',
            'about' => $get_about
        ]);
    }

    public function news()
    {
        if(session('is_login') != 1)
        {
            return redirect('');
        }

        return view('landing-page.news.view',[
            'title' => 'News',
            'menu' => 'landing-page',
            'sub_menu' => 'news'
        ]);
    }

    public function add_news()
    {
        if(session('is_login') != 1)
        {
            return redirect('');
        }

        return view('landing-page.news.add',[
            'title' => 'Add News',
            'menu' => 'landing-page',
            'sub_menu' => 'news'
        ]);
    }

    public function edit_news(Request $req)
    {
        if(session('is_login') != 1)
        {
            return redirect('');
        }

        $get_news = std_get([
            'table_name' => 'news',
            'first_row' => true,
            'where' => [
                [
                    'field_name' => 'news_id',
                    'operator' => '=',
                    'value' => $req->id
                ]
            ]
        ]);

        if($get_news == NULL)
        {
            return view('errors.404');
        }

        return view('landing-page.news.edit',[
            'title' => 'Edit News',
            'menu' => 'landing-page',
            'sub_menu' => 'news',
            'news' => $get_news
        ]);
    }

    public function loker()
    {
        if(session('is_login') != 1)
        {
            return redirect('');
        }

        return view('landing-page.loker.view',[
            'title' => 'Loker',
            'menu' => 'landing-page',
            'sub_menu' => 'loker'
        ]);
    }

    public function add_loker()
    {
        if(session('is_login') != 1)
        {
            return redirect('');
        }

        return view('landing-page.loker.add',[
            'title' => 'Add Loker',
            'menu' => 'landing-page',
            'sub_menu' => 'loker'
        ]);
    }

    public function edit_loker(Request $req)
    {
        if(session('is_login') != 1)
        {
            return redirect('');
        }

        $get_loker = std_get([
            'table_name' => 'loker',
            'first_row' => true,
            'where' => [
                [
                    'field_name' => 'loker_id',
                    'operator' => '=',
                    'value' => $req->id
                ]
            ]
        ]);

        if($get_loker == NULL)
        {
            return view('errors.404');
        }

        return view('landing-page.loker.edit',[
            'title' => 'Edit Loker',
            'menu' => 'landing-page',
            'sub_menu' => 'loker',
            'loker' => $get_loker
        ]);
    }

    public function service()
    {
        if(session('is_login') != 1)
        {
            return redirect('');
        }

        return view('landing-page.service.view',[
            'title' => 'Service',
            'menu' => 'landing-page',
            'sub_menu' => 'service',
        ]);
    }

    public function add_service()
    {
        if(session('is_login') != 1)
        {
            return redirect('');
        }

        return view('landing-page.service.add',[
            'title' => 'Service',
            'menu' => 'landing-page',
            'sub_menu' => 'service',
        ]);
    }

    public function edit_service(Request $req)
    {
        if(session('is_login') != 1)
        {
            return redirect('');
        }

        $get_service = std_get([
            'table_name' => 'service',
            'first_row' => true,
            'where' => [
                [
                    'field_name' => 'service_id',
                    'operator' => '=',
                    'value' => $req->id
                ]
            ]
        ]);

        if($get_service == NULL)
        {
            return view('errors.404');
        }

        return view('landing-page.service.edit',[
            'title' => 'Edit Service',
            'menu' => 'landing-page',
            'sub_menu' => 'service',
            'service' => $get_service
        ]);
    }

    public function clients()
    {
        if(session('is_login') != 1)
        {
            return redirect('');
        }

        return view('landing-page.clients.view',[
            'title' => 'Client',
            'menu' => 'landing-page',
            'sub_menu' => 'clients',
        ]);
    }

}
