<?php

namespace App\Http\Controllers\Modal;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class Client extends Controller
{
    public function add()
    {
        $html = '<form method="post" id="add" enctype="multipart/form-data">
                    '.csrf_field().'
                    <div class="form-group row">
                        <label class="col-md-4">Image</label>
                        <input type="file" name="client_image"  class="form-control col-md-6">
                    </div>
                    <div class="form-group row">
                        <label class="col-md-4">Image alt</label>
                        <input type="text" name="client_image_alt"  class="form-control col-md-6" placeholder="Image Alt">
                    </div>
                    <div class="form-group row">
                        <button class="btn btn-primary ml-5" id="addBtn" type="submit">
                            <i class="fas fa-check"></i> Save
                        </button>
                    </div>
                </form>';

        return response()->json([
            'title' => 'Add New Client',
            'html' => $html
        ]);
    }

    function edit(Request $req)
    {
        $html= '';

        if(isset($req->id))
        {
            $get_client = std_get([
                'table_name' => 'client',
                'first_row' => true,
                'where' => [
                    [
                        'field_name' => 'client_id',
                        'operator' => '=',
                        'value' => $req->id
                    ]
                ]
            ]);

            $html = '<form method="post" id="edit" enctype="multipart/form-data">
                    '.csrf_field().'
                    <input type="hidden" name="client_id" value="'.$get_client['client_id'].'">
                    <div class="form-group row">
                        <label class="col-md-4">Image</label>
                        <input type="file" name="client_image" class="form-control col-md-6">
                    </div>
                    <div class="form-group row">
                        <label class="col-md-4">Image alt</label>
                        <input type="text" name="client_image_alt"  class="form-control col-md-6" placeholder="Image Alt" value="'.$get_client['client_image_alt'].'">
                    </div>
                    <div class="form-group row">
                        <button class="btn btn-primary ml-5" id="editBtn" type="submit">
                            <i class="fas fa-edit"></i> Update
                        </button>
                    </div>
                </form>';
        }

        return response()->json([
            'title' => 'Edit Client',
            'html' => $html
        ]);
    }
}
