<?php

namespace App\Http\Controllers\Modal;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class Admin extends Controller
{
    public function add()
    {
        $html = '<form method="post" id="add" enctype="multipart/form-data">
                    '.csrf_field().'
                    <div class="form-group row">
                        <label class="col-md-4">Username</label>
                        <input type="text" name="username"  class="form-control col-md-6" placeholder="Username">
                    </div>
                    <div class="form-group row">
                        <label class="col-md-4">Password</label>
                        <input type="text" name="password" class="form-control col-md-6" placeholder="Password">
                    </div>
                    <div class="form-group row">
                        <button class="btn btn-primary ml-5" id="addBtn" type="submit">
                            <i class="fas fa-check"></i> Save
                        </button>
                    </div>
                </form>';

        return response()->json([
            'title' => 'Add New Admin',
            'html' => $html
        ]);
    }

    function edit(Request $req)
    {
        $html= '';

        if(isset($req->id))
        {
            $get_admin = std_get([
                'table_name' => 'admin',
                'first_row' => true,
                'where' => [
                    [
                        'field_name' => 'admin_id',
                        'operator' => '=',
                        'value' => $req->id
                    ]
                ]
            ]);

            $html = '<form method="post" id="edit" enctype="multipart/form-data">
                    '.csrf_field().'
                    <input type="hidden" name="id" value="'.$get_admin['admin_id'].'">
                    <div class="form-group row">
                        <label class="col-md-4">Username</label>
                        <input type="text" name="username"  class="form-control col-md-6" placeholder="Username"  value="'.$get_admin['admin_username'].'">
                    </div>
                    <div class="form-group row">
                        <button class="btn btn-primary ml-5" id="editBtn" type="submit">
                            <i class="fas fa-edit"></i> Update
                        </button>
                    </div>
                </form>';
        }

        return response()->json([
            'title' => 'Edit Admin ('.$get_admin['admin_username'].')',
            'html' => $html
        ]);
    }
}
