<?php

namespace App\Http\Controllers\Misc;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\File;

class Service extends Controller
{
    public function add(Request $req)
    {
        $validate = Validator::make($req->all(),[
            'service_title' => 'required|unique:service,service_title|max:255',
            'service_url' => 'required|unique:service,service_url|max:255',
            'service_text' => 'required|max:400000',
            'service_image' => 'required|file|image|mimes:jpg,jpeg,png',
            'service_image_alt' => 'required|max:255',
            'service_meta_description' => 'required|max:65000',
        ]);

        $validate->setAttributeNames([
            'service_title' => 'Title',
            'service_url' => 'URL',
            'service_text' => 'Text',
            'service_image' => 'Image',
            'service_image_alt' => 'Image Alt',
            'service_meta_description' => 'Meta Description',

        ]);

        if($validate->fails())
        {
            return response()->json([
                'status' => 'warning',
                'warning' => 'Invalid',
                'message' => $validate->errors()->all()
            ]);
        }

        $photo = $req->file('service_image');
        $ext = $photo->getClientOriginalExtension();
        $new_name = time().'.'.$ext;

        if($photo->move('public/storage/uploaded/service_image/', $new_name))
        {
            $insert_service = std_insert([
                'table_name' => 'service',
                'data' => [
                    'service_title' => $req->service_title,
                    'service_url' => $req->service_url,
                    'service_text' => $req->service_text,
                    'service_image' => $new_name,
                    'service_image_alt' => $req->service_image_alt,
                    'service_meta_description' => $req->service_meta_description,
                    'created_by' => session('id'),
                    'created_by_text' => session('username'),
                    'created_by_timestamp' => date('Y-m-d H:i:s'),
                    'service_status' => 1
                ]
            ]);

            if($insert_service === false)
            {
                return response()->json([
                    'status' => 'error',
                    'warning' => 'Internal Server Error',
                    'message' => 'Something went wrong when saving data'
                ]);
            }

            return response()->json([
                'status' => 'success',
                'warning' => 'Successfully Saved',
                'message' => ''
            ]);
        }else {
            return response()->json([
                'status' => 'error',
                'warning' => 'Internal Server Error',
                'message' => 'Something went wrong when saving data'
            ]);
        }
    }

    public function edit(Request $req)
    {
        $validate = Validator::make($req->all(),[
        	'service_id' => 'required|exists:service,service_id',
            'service_title' => 'required|max:255',
            'service_url' => 'required|max:255',
            'service_text' => 'required|max:400000',
            'service_image' => 'file|image|mimes:jpg,jpeg,png',
            'service_image_alt' => 'required|max:255',
            'service_meta_description' => 'required|max:65000',
        ]);

        $validate->setAttributeNames([
        	'service_id' => 'Service ID',
            'service_title' => 'Title',
            'service_url' => 'URL',
            'service_text' => 'Text',
            'service_image' => 'Image',
            'service_image_alt' => 'Image Alt',
            'service_meta_description' => 'Meta Description',
        ]);

        if($validate->fails())
        {
            return response()->json([
                'status' => 'warning',
                'warning' => 'Invalid',
                'message' => $validate->errors()->all()
            ]);
        }

        $get_service = std_get([
            'table_name' => 'service',
            'first_row' => true,
            'where' => [
                [
                    'field_name' => 'service_id',
                    'operator' => '=',
                    'value' => $req->service_id
                ]
            ]
        ]);

        if($req->service_title != $get_service['service_title'])
        {
            $cek_title = std_get([
                'table_name' => 'service',
                'where' => [
                    [
                        'field_name' => 'service_title',
                        'operator' => '=',
                        'value' => $req->service_title
                    ]
                ]
            ]);

            if(count($cek_title) > 0)
            {
                return response()->json([
                    'status' => 'warning',
                    'warning' => 'Invalid',
                    'message' => 'Title already exists'
                ]);
            }
        }

        if($req->service_url != $get_service['service_url'])
        {
            $cek_url = std_get([
                'table_name' => 'service',
                'where' => [
                    [
                        'field_name' => 'service_url',
                        'operator' => '=',
                        'value' => $req->service_url
                    ]
                ]
            ]);

            if(count($cek_url) > 0)
            {
                return response()->json([
                    'status' => 'warning',
                    'warning' => 'Invalid',
                    'message' => 'URL already exists'
                ]);
            }
        }

        $update_data = [
            'service_title' => $req->service_title,
            'service_url' => $req->service_url,
            'service_text' => $req->service_text,
            'service_image_alt' => $req->service_image_alt,
            'service_meta_description' => $req->service_meta_description,
            'updated_by' => session('id'),
            'updated_by_text' => session('username'),
            'updated_by_timestamp' => date("Y-m-d H:i:s")
        ];

        if($req->service_image != NULL || $req->service_image != "")
        {
            $path_photo = 'public/storage/uploaded/service_image/'.$get_service['service_image'];

            if(is_file($path_photo))
            {
                File::delete($path_photo);
            }

            $photo = $req->file('service_image');
            $ext = $photo->getClientOriginalExtension();
            $new_name = time().'.'.$ext;

            if($photo->move('public/storage/uploaded/service_image/', $new_name))
            {
                $update_data['service_image'] = $new_name;
            }else{
                return response()->json([
                    'status' => 'error',
                    'warning' => 'Internal Server Error',
                    'message' => 'Something went wrong when uploading image to server'
                ]);
            }
        }

        $update_service = std_update([
            'table_name' => 'service',
            'data' => $update_data,
            'where' => [
                'service_id' => $req->service_id
            ]
        ]);

        if($update_service === false)
        {
            return response()->json([
                'status' => 'error',
                'warning' => 'Internal Server Error',
                'message' => 'Something went wrong when saving data'
            ]);
        }

        return response()->json([
            'status' => 'success',
            'warning' => 'Successfully Updated',
            'message' => ''
        ]);
    }

    public function statusChange(Request $req)
    {
        $validate = Validator::make($req->all(),[
            'id' => 'required|exists:service,service_id',
            'status' => 'required|in:0,1,2',
        ]);

        $validate->setAttributeNames([
            'id' => 'ID',
            'status' => 'Status',
        ]);

        if($validate->fails())
        {
            return response()->json([
                'status' => 'warning',
                'warning' => 'Invalid',
                'message' => $validate->errors()->all()
            ]);
        }

        $update_service = std_update([
            'table_name' => 'service',
            'where' => [
                'service_id' => $req->id
            ],
            'data' => [
                'service_status' => $req->status,
                'updated_by' => session('id'),
                'updated_by_text' => session('username'),
                'updated_by_timestamp' => date("Y-m-d H:i:s")
            ]
        ]);

        if($update_service === false)
        {
            return response()->json([
                'status' => 'error',
                'warning' => 'Internal Server Error',
                'message' => 'Something went wrong when updating news'
            ]);
        }

        return response()->json([
            'status' => 'success',
            'warning' => 'Successfully Updated',
            'message' => 'Service Updated'
        ]);
    }
}
