<?php

namespace App\Http\Controllers\Misc;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\File;
class News extends Controller
{
    public function add(Request $req)
    {
        $validate = Validator::make($req->all(),[
            'news_title' => 'required|max:255|unique:news,news_title',
            'news_image' => 'required|file|image|mimes:jpg,jpeg,png',
            'news_image_alt' => 'required|max:255',
            'news_text' => 'required|max:4000000',
            'news_url' => 'required|unique:news,news_url|max:255',
            'news_meta_description' => 'required|max:65000'
        ]);

        $validate->setAttributeNames([
            'news_title' => 'News Title',
            'news_image' => 'News Image',
            'news_image_alt' => 'News Image Alt',
            'news_text' => 'News Text',
            'news_url' => 'News Url',
            'news_meta_description' => 'News Meta Description'
        ]);

        if($validate->fails())
        {
            return response()->json([
                'status' => 'warning',
                'warning' => 'Invalid',
                'message' => $validate->errors()->all()
            ]);
        }

        $photo = $req->file('news_image');
        $ext = $photo->getClientOriginalExtension();
        $new_name = time().'.'.$ext;

        if($photo->move('public/storage/uploaded/news_image/', $new_name))
        {
            $insert_news = std_insert([
                'table_name' => 'news',
                'data' => [
                    'news_title' => $req->news_title,
                    'news_image' => $new_name,
                    'news_image_alt' => $req->news_image_alt,
                    'news_text' => $req->news_text,
                    'news_url' => $req->news_url,
                    'news_meta_description' => $req->news_meta_description,
                    'news_status' => 1,
                    'created_by' => session('id'),
                    'created_by_text' => session('username'),
                    'created_by_timestamp' => date("Y-m-d H:i:s")
                ]
            ]);

            if($insert_news === false)
            {
                return response()->json([
                    'status' => 'error',
                    'warning' => 'Internal Server Error',
                    'message' => 'Something went wrong when saving news'
                ]);
            }

            return response()->json([
                'status' => 'success',
                'warning' => 'Successfully Saved',
                'message' => 'News saved'
            ]);
        }else{
            return response()->json([
                'status' => 'error',
                'warning' => 'Internal Server Error',
                'message' => 'Something went wrong when uploading image to server'
            ]);
        }

    }

    public function edit(Request $req)
    {
        $validate = Validator::make($req->all(),[
            'news_id' => 'required|exists:news,news_id',
            'news_title' => 'required|max:255',
            'news_image' => 'file|image|mimes:jpg,jpeg,png',
            'news_image_alt' => 'required|max:255',
            'news_text' => 'required|max:4000000',
            'news_url' => 'required|max:255',
            'news_meta_description' => 'required|max:65000'
        ]);

        $validate->setAttributeNames([
            'news_id' => 'News ID',
            'news_title' => 'News Title',
            'news_image' => 'News Image',
            'news_image_alt' => 'News Image Alt',
            'news_text' => 'News Text',
            'news_url' => 'News Url',
            'news_meta_description' => 'News Meta Description'
        ]);

        if($validate->fails())
        {
            return response()->json([
                'status' => 'warning',
                'warning' => 'Invalid',
                'message' => $validate->errors()->all()
            ]);
        }

        $get_news = std_get([
            'table_name' => 'news',
            'first_row' => true,
            'where' => [
                [
                    'field_name' => 'news_id',
                    'operator' => '=',
                    'value' => $req->news_id
                ]
            ]
        ]);

        if($get_news['news_title'] != $req->news_title)
        {
            $check_title = std_get([
                'table_name' => 'news',
                'where' => [
                    [
                        'field_name' => 'news_title',
                        'operator' => '=',
                        'value' => $req->news_title
                    ]
                ]
            ]);

            if(count($check_title) > 0)
            {
                return response()->json([
                    'status' => 'warning',
                    'warning' => 'Title Unavailable',
                    'message' => ''
                ]);
            }
        }

        $update_data = [
            'news_title' => $req->news_title,
            'news_image_alt' => $req->news_image_alt,
            'news_text' => $req->news_text,
            'news_url' => $req->news_url,
            'news_meta_description' => $req->news_meta_description,
            'updated_by' => session('id'),
            'updated_by_text' => session('username'),
            'updated_by_timestamp' => date("Y-m-d H:i:s")
        ];

        if($req->news_image != NULL || $req->news_image != "")
        {
            $path_photo = 'public/storage/uploaded/news_image/'.$get_news['news_image'];

            if(is_file($path_photo))
            {
                File::delete($path_photo);
            }

            $photo = $req->file('news_image');
            $ext = $photo->getClientOriginalExtension();
            $new_name = time().'.'.$ext;

            if($photo->move('public/storage/uploaded/news_image/', $new_name))
            {
                $update_data['news_image'] = $new_name;
            }else{
                return response()->json([
                    'status' => 'error',
                    'warning' => 'Internal Server Error',
                    'message' => 'Something went wrong when uploading image to server'
                ]);
            }
        }

        $update_news = std_update([
            'table_name' => 'news',
            'data' => $update_data,
            'where' => [
               'news_id' => $req->news_id
            ]
        ]);

        if($update_news === false)
        {
            return response()->json([
                'status' => 'error',
                'warning' => 'Internal Server Error',
                'message' => 'Something went wrong when updating news'
            ]);
        }

        return response()->json([
            'status' => 'success',
            'warning' => 'Successfully Updated',
            'message' => 'News Updated'
        ]);
    }

    public function statusChange(Request $req)
    {
        $validate = Validator::make($req->all(),[
            'id' => 'required|exists:news,news_id',
            'status' => 'required|in:0,1,2',
        ]);

        $validate->setAttributeNames([
            'id' => 'ID',
            'status' => 'Status'
        ]);

        if($validate->fails())
        {
            return response()->json([
                'status' => 'warning',
                'warning' => 'Invalid',
                'message' => $validate->errors()->all()
            ]);
        }

        $update_news = std_update([
            'table_name' => 'news',
            'where' => [
                'news_id' => $req->id
            ],
            'data' => [
                'news_status' => $req->status,
                'updated_by' => session('id'),
                'updated_by_text' => session('username'),
                'updated_by_timestamp' => date("Y-m-d H:i:s")
            ]
        ]);

        if($update_news === false)
        {
            return response()->json([
                'status' => 'error',
                'warning' => 'Internal Server Error',
                'message' => 'Something went wrong when updating news'
            ]);
        }

        return response()->json([
            'status' => 'success',
            'warning' => 'Successfully Updated',
            'message' => 'News Updated'
        ]);
    }
}
