<?php

namespace App\Http\Controllers\Misc;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\File;
class Loker extends Controller
{
    public function add(Request $req)
    {
        $validate = Validator::make($req->all(),[
            'loker_title' => 'required|max:255|unique:loker,loker_title',
            'loker_image' => 'required|file|image|mimes:jpg,jpeg,png',
            'loker_image_alt' => 'required|max:255',
            'loker_text' => 'required|max:4000000',
            'loker_url' => 'required|unique:loker,loker_url|max:255',
            'loker_meta_description' => 'required|max:65000'
        ]);

        $validate->setAttributeNames([
            'loker_title' => 'loker Title',
            'loker_image' => 'loker Image',
            'loker_image_alt' => 'loker Image Alt',
            'loker_text' => 'loker Text',
            'loker_url' => 'loker Url',
            'loker_meta_description' => 'loker Meta Description'
        ]);

        if($validate->fails())
        {
            return response()->json([
                'status' => 'warning',
                'warning' => 'Invalid',
                'message' => $validate->errors()->all()
            ]);
        }

        $photo = $req->file('loker_image');
        $ext = $photo->getClientOriginalExtension();
        $new_name = time().'.'.$ext;

        if($photo->move('public/storage/uploaded/loker_image/', $new_name))
        {
            $insert_loker = std_insert([
                'table_name' => 'loker',
                'data' => [
                    'loker_title' => $req->loker_title,
                    'loker_image' => $new_name,
                    'loker_image_alt' => $req->loker_image_alt,
                    'loker_text' => $req->loker_text,
                    'loker_url' => $req->loker_url,
                    'loker_meta_description' => $req->loker_meta_description,
                    'loker_status' => 1,
                    'created_by' => session('id'),
                    'created_by_text' => session('username'),
                    'created_by_timestamp' => date("Y-m-d H:i:s")
                ]
            ]);

            if($insert_loker === false)
            {
                return response()->json([
                    'status' => 'error',
                    'warning' => 'Internal Server Error',
                    'message' => 'Something went wrong when saving loker'
                ]);
            }

            return response()->json([
                'status' => 'success',
                'warning' => 'Successfully Saved',
                'message' => 'loker saved'
            ]);
        }else{
            return response()->json([
                'status' => 'error',
                'warning' => 'Internal Server Error',
                'message' => 'Something went wrong when uploading image to server'
            ]);
        }

    }

    public function edit(Request $req)
    {
        $validate = Validator::make($req->all(),[
            'loker_id' => 'required|exists:loker,loker_id',
            'loker_title' => 'required|max:255',
            'loker_image' => 'file|image|mimes:jpg,jpeg,png',
            'loker_image_alt' => 'required|max:255',
            'loker_text' => 'required|max:4000000',
            'loker_url' => 'required|max:255',
            'loker_meta_description' => 'required|max:65000'
        ]);

        $validate->setAttributeNames([
            'loker_id' => 'loker ID',
            'loker_title' => 'loker Title',
            'loker_image' => 'loker Image',
            'loker_image_alt' => 'loker Image Alt',
            'loker_text' => 'loker Text',
            'loker_url' => 'loker Url',
            'loker_meta_description' => 'loker Meta Description'
        ]);

        if($validate->fails())
        {
            return response()->json([
                'status' => 'warning',
                'warning' => 'Invalid',
                'message' => $validate->errors()->all()
            ]);
        }

        $get_loker = std_get([
            'table_name' => 'loker',
            'first_row' => true,
            'where' => [
                [
                    'field_name' => 'loker_id',
                    'operator' => '=',
                    'value' => $req->loker_id
                ]
            ]
        ]);

        if($get_loker['loker_title'] != $req->loker_title)
        {
            $check_title = std_get([
                'table_name' => 'loker',
                'where' => [
                    [
                        'field_name' => 'loker_title',
                        'operator' => '=',
                        'value' => $req->loker_title
                    ]
                ]
            ]);

            if(count($check_title) > 0)
            {
                return response()->json([
                    'status' => 'warning',
                    'warning' => 'Title Unavailable',
                    'message' => ''
                ]);
            }
        }

        $update_data = [
            'loker_title' => $req->loker_title,
            'loker_image_alt' => $req->loker_image_alt,
            'loker_text' => $req->loker_text,
            'loker_url' => $req->loker_url,
            'loker_meta_description' => $req->loker_meta_description,
            'updated_by' => session('id'),
            'updated_by_text' => session('username'),
            'updated_by_timestamp' => date("Y-m-d H:i:s")
        ];

        if($req->loker_image != NULL || $req->loker_image != "")
        {
            $path_photo = 'public/storage/uploaded/loker_image/'.$get_loker['loker_image'];

            if(is_file($path_photo))
            {
                File::delete($path_photo);
            }

            $photo = $req->file('loker_image');
            $ext = $photo->getClientOriginalExtension();
            $new_name = time().'.'.$ext;

            if($photo->move('public/storage/uploaded/loker_image/', $new_name))
            {
                $update_data['loker_image'] = $new_name;
            }else{
                return response()->json([
                    'status' => 'error',
                    'warning' => 'Internal Server Error',
                    'message' => 'Something went wrong when uploading image to server'
                ]);
            }
        }

        $update_loker = std_update([
            'table_name' => 'loker',
            'data' => $update_data,
            'where' => [
               'loker_id' => $req->loker_id
            ]
        ]);

        if($update_loker === false)
        {
            return response()->json([
                'status' => 'error',
                'warning' => 'Internal Server Error',
                'message' => 'Something went wrong when updating loker'
            ]);
        }

        return response()->json([
            'status' => 'success',
            'warning' => 'Successfully Updated',
            'message' => 'loker Updated'
        ]);
    }

    public function statusChange(Request $req)
    {
        $validate = Validator::make($req->all(),[
            'id' => 'required|exists:loker,loker_id',
            'status' => 'required|in:0,1,2',
        ]);

        $validate->setAttributeNames([
            'id' => 'ID',
            'status' => 'Status'
        ]);

        if($validate->fails())
        {
            return response()->json([
                'status' => 'warning',
                'warning' => 'Invalid',
                'message' => $validate->errors()->all()
            ]);
        }

        $update_loker = std_update([
            'table_name' => 'loker',
            'where' => [
                'loker_id' => $req->id
            ],
            'data' => [
                'loker_status' => $req->status,
                'updated_by' => session('id'),
                'updated_by_text' => session('username'),
                'updated_by_timestamp' => date("Y-m-d H:i:s")
            ]
        ]);

        if($update_loker === false)
        {
            return response()->json([
                'status' => 'error',
                'warning' => 'Internal Server Error',
                'message' => 'Something went wrong when updating loker'
            ]);
        }

        return response()->json([
            'status' => 'success',
            'warning' => 'Successfully Updated',
            'message' => 'Loker Updated'
        ]);
    }
}
