<?php

namespace App\Http\Controllers\Misc;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\File;

class Client extends Controller
{
    public function add(Request $req)
    {
        $validate = Validator::make($req->all(),[
            'client_image' => 'required|file|image|mimes:jpg,jpeg,png',
            'client_image_alt' => 'required|max:255',
        ]);

        $validate->setAttributeNames([
            'client_image' => 'Image',
            'client_image_alt' => 'Image Alt',

        ]);

        if($validate->fails())
        {
            return response()->json([
                'status' => 'warning',
                'warning' => 'Invalid',
                'message' => $validate->errors()->all()
            ]);
        }

        $photo = $req->file('client_image');
        $ext = $photo->getClientOriginalExtension();
        $new_name = time().'.'.$ext;

        if($photo->move('public/storage/uploaded/client_image/', $new_name))
        {
            $insert_client = std_insert([
                'table_name' => 'client',
                'data' => [
                    'client_image' => $new_name,
                    'client_image_alt' => $req->client_image_alt,
                    'created_by' => session('id'),
                    'created_by_text' => session('username'),
                    'created_by_timestamp' => date('Y-m-d H:i:s'),
                    'client_status' => 1
                ]
            ]);

            if($insert_client === false)
            {
                return response()->json([
                    'status' => 'error',
                    'warning' => 'Internal Server Error',
                    'message' => 'Something went wrong when saving data'
                ]);
            }

            return response()->json([
                'status' => 'success',
                'warning' => 'Successfully Saved',
                'message' => ''
            ]);
        }else {
            return response()->json([
                'status' => 'error',
                'warning' => 'Internal Server Error',
                'message' => 'Something went wrong when saving data'
            ]);
        }
    }

    public function edit(Request $req)
    {
        $validate = Validator::make($req->all(),[
        	'client_id' => 'required|exists:client,client_id',
            'client_image' => 'file|image|mimes:jpg,jpeg,png',
            'client_image_alt' => 'required|max:255'
        ]);

        $validate->setAttributeNames([
        	'client_id' => 'Client ID',
            'client_image' => 'Image',
            'client_image_alt' => 'Image Alt'
        ]);

        if($validate->fails())
        {
            return response()->json([
                'status' => 'warning',
                'warning' => 'Invalid',
                'message' => $validate->errors()->all()
            ]);
        }

        $get_client = std_get([
            'table_name' => 'client',
            'first_row' => true,
            'where' => [
                [
                    'field_name' => 'client_id',
                    'operator' => '=',
                    'value' => $req->client_id
                ]
            ]
        ]);

        $update_data = [
            'client_image_alt' => $req->client_image_alt,
            'updated_by' => session('id'),
            'updated_by_text' => session('username'),
            'updated_by_timestamp' => date("Y-m-d H:i:s")
        ];

        if($req->client_image != NULL || $req->client_image != "")
        {
            $path_photo = 'public/storage/uploaded/client_image/'.$get_client['client_image'];

            if(is_file($path_photo))
            {
                File::delete($path_photo);
            }

            $photo = $req->file('client_image');
            $ext = $photo->getClientOriginalExtension();
            $new_name = time().'.'.$ext;

            if($photo->move('public/storage/uploaded/client_image/', $new_name))
            {
                $update_data['client_image'] = $new_name;
            }else{
                return response()->json([
                    'status' => 'error',
                    'warning' => 'Internal Server Error',
                    'message' => 'Something went wrong when uploading image to server'
                ]);
            }
        }

        $update_client = std_update([
            'table_name' => 'client',
            'data' => $update_data,
            'where' => [
                'client_id' => $req->client_id
            ]
        ]);

        if($update_client === false)
        {
            return response()->json([
                'status' => 'error',
                'warning' => 'Internal Server Error',
                'message' => 'Something went wrong when saving data'
            ]);
        }

        return response()->json([
            'status' => 'success',
            'warning' => 'Successfully Updated',
            'message' => ''
        ]);
    }

    public function statusChange(Request $req)
    {
        $validate = Validator::make($req->all(),[
            'id' => 'required|exists:client,client_id',
            'status' => 'required|in:0,1,2',
        ]);

        $validate->setAttributeNames([
            'id' => 'ID',
            'status' => 'Status',
        ]);

        if($validate->fails())
        {
            return response()->json([
                'status' => 'warning',
                'warning' => 'Invalid',
                'message' => $validate->errors()->all()
            ]);
        }

        $update_client = std_update([
            'table_name' => 'client',
            'where' => [
                'client_id' => $req->id
            ],
            'data' => [
                'client_status' => $req->status,
                'updated_by' => session('id'),
                'updated_by_text' => session('username'),
                'updated_by_timestamp' => date("Y-m-d H:i:s")
            ]
        ]);

        if($update_client === false)
        {
            return response()->json([
                'status' => 'error',
                'warning' => 'Internal Server Error',
                'message' => 'Something went wrong when updating news'
            ]);
        }

        return response()->json([
            'status' => 'success',
            'warning' => 'Successfully Updated',
            'message' => 'Client Updated'
        ]);
    }
}
