<?php

namespace App\Http\Controllers\Misc;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class Admin extends Controller
{
    public function add(Request $req)
    {
        $validate = Validator::make($req->all(),[
            'username' => 'required|max:255|unique:admin,admin_username',
            'password' => 'required|max:255'
        ]);

        $validate->setAttributeNames([
            'username' => 'Username',
            'password' => 'Password'
        ]);

        if($validate->fails())
        {
            return response()->json([
                'status' => 'warning',
                'warning' => 'Invalid',
                'message' => $validate->errors()->all()
            ]);
        }

        $insert_admin = std_insert([
            'table_name' => 'admin',
            'data' => [
                'admin_username' => $req->username,
                'admin_password' => md5($req->password),
                'created_by' => session('id'),
                'created_by_text' => session('username'),
                'created_by_timestamp' => date('Y-m-d H:i:s'),
                'admin_status' => 1
            ]
        ]);

        if($insert_admin === false)
        {
            return response()->json([
                'status' => 'error',
                'warning' => 'Internal Server Error',
                'message' => 'Something went wrong when saving data'
            ]);
        }

        return response()->json([
            'status' => 'success',
            'warning' => 'Successfully Saved',
            'message' => ''
        ]);
    }

    public function edit(Request $req)
    {
        $validate = Validator::make($req->all(),[
            'id' => 'required|exists:admin,admin_id',
            'username' => 'required|max:255',
        ]);

        $validate->setAttributeNames([
            'username' => 'Username',
        ]);

        if($validate->fails())
        {
            return response()->json([
                'status' => 'warning',
                'warning' => 'Invalid',
                'message' => $validate->errors()->all()
            ]);
        }

        $get_admin = std_get([
            'table_name' => 'admin',
            'first_row' => true,
            'where' => [
                [
                    'field_name' => 'admin_id',
                    'operator' => '=',
                    'value' => $req->id
                ]
            ]
        ]);

        if($req->username != $get_admin['admin_username'])
        {
            $check_username = std_get([
                'table_name' => 'admin',
                'where' => [
                    [
                        'field_name' => 'admin_username',
                        'operator' => '=',
                        'value' => $req->username
                    ]
                ]
            ]);

            if(count($check_username) > 0)
            {
                return response()->json([
                    'status' => 'warning',
                    'warning' => 'Username unavailable',
                    'message' => 'Username has already been taken'
                ]);
            }
        }


        $update_admin = std_update([
            'table_name' => 'admin',
            'data' => [
                'admin_username' => $req->username,
                'admin_password' => md5($req->password),
                'updated_by' => session('id'),
                'updated_by_text' => session('username'),
                'updated_by_timestamp' => date('Y-m-d H:i:s')
            ],
            'where' => [
                'admin_id' => $req->id
            ]
        ]);

        if($update_admin === false)
        {
            return response()->json([
                'status' => 'error',
                'warning' => 'Internal Server Error',
                'message' => 'Something went wrong when saving data'
            ]);
        }

        return response()->json([
            'status' => 'success',
            'warning' => 'Successfully Updated',
            'message' => ''
        ]);
    }

    public function ban_status(Request $req)
    {
        $validate = Validator::make($req->all(),[
            'id' => 'required|exists:admin,admin_id',
            'status' => 'required|in:0,1,2',
        ]);

        $validate->setAttributeNames([
            'id' => 'User',
            'status' => 'Status',
        ]);

        if($validate->fails())
        {
            return response()->json([
                'status' => 'warning',
                'warning' => 'Invalid',
                'message' => $validate->errors()->all()
            ]);
        }

        $update_admin = std_update([
            'table_name' => 'admin',
            'data' => [
                'admin_status' => $req->status,
                'updated_by' => session('id'),
                'updated_by_text' => session('username'),
                'updated_by_timestamp' => date('Y-m-d H:i:s')
            ],
            'where' => [
                'admin_id' => $req->id
            ]
        ]);

        if($update_admin === false)
        {
            return response()->json([
                'status' => 'error',
                'warning' => 'Internal Server Error',
                'message' => 'Something went wrong when updating admin'
            ]);
        }

        return response()->json([
            'status' => 'success',
            'warning' => 'Successfully Updated',
            'message' => 'Status Changed'
        ]);
    }
}
