<?php

namespace App\Http\Controllers\Misc;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class About extends Controller
{
    public function edit(Request $req)
    {
        $validator = Validator::make($req->all(),[
            'about_id' => 'required|exists:about,about_id',
            'about_desc_ina' => 'required|max:4000000',
            // 'about_desc_eng' => 'required|max:4000000'
        ]);

        $validator->setAttributeNames([
            'about_id' => 'ID',
            'about_desc_ina' => 'About (Indonesian)',
            // 'about_desc_eng' => 'About (English)'
        ]);

        if($validator->fails())
        {
            return response()->json([
                'status' => 'warning',
                'warning' => 'Invalid',
                'message' => $validator->errors()->all()
            ]);
        }

        $update_about = std_update([
            'table_name' => 'about',
            'where' => [
                'about_id' => $req->about_id
            ],
            'data' => [
                'about_desc_ina' => $req->about_desc_ina,
                // 'about_desc_eng' => $req->about_desc_eng,
                'updated_by' => session('id'),
                'updated_by_text' => session('username'),
                'updated_by_timestamp' => date('Y-m-d H:i:s')
            ]
        ]);

        if($update_about === false)
        {
            return response()->json([
                'status' => 'error',
                'warning' => 'Internal Server Error',
                'message' => 'Something went wrong when updating about'
            ]);
        }

        return response()->json([
            'status' => 'success',
            'warning' => 'Successfully Updated',
            'message' => 'About updated'
        ]);
    }
}
