<?php

namespace App\Http\Controllers\Data;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class Service extends Controller
{
    public function index()
    {
        $html = '<div class=" col-lg-12 row mb-5">
                    <a href="add_service" class="btn btn-primary mr-2"><i class="fas fa-plus"></i> Add Service</a>
                    <button onClick="get_service()" class="btn btn-danger"><i class="fas fa-refresh"></i></button>
                </div>
        <table id="data" class="table table-borderless table-striped table-earning">
            <thead>
                <tr>
                    <th></th>
                    <th>Image</th>
                    <th>Text</th>
                    <th>Meta Description</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>';

        $get_service = std_get([
            'table_name' => 'service',
            'order_by' => [
                [
                    'field' => 'created_by_timestamp',
                    'type' => 'DESC'
                ]
            ],
            'where' => [
                [
                    'field_name' => 'service_status',
                    'operator' => '!=',
                    'value' => 2
                ],

            ]
        ]);

        if(count($get_service) > 0)
        {
            foreach($get_service as $d)
            {
                $status = $d['service_status'];
                // $username = "'".$d['admin_username']."'";

                if($status == 1)
                {
                    $status = '<i class="badge badge-success">Active<i/>';
                    $banBtn = '<button onClick="banStatus('.$d['service_id'].',0)" class="btn mr-1">
                                    <i class="fas fa-ban"></i>
                                </button>';
                } elseif($status == 0)
                {
                    $status = '<i class="badge badge-danger">Hidden<i/>';
                    $banBtn = '<button onClick="banStatus('.$d['service_id'].',1)" class="btn mr-1">
                                    <i class="fas fa-check"></i>
                                </button>';
                }
                $html .= '<tr>
                            <td></td>
                            <td>
                                <img src="./storage/uploaded/service_image/'.$d['service_image'].'" style="width: 100px; object-fot: contain;" />
                            </td>
                            <td>'.$d['service_text'].'</td>
                            <td>'.$d['service_meta_description'].'</td>
                            <td>'.$status.'</td>
                            <td>
                                <a href="edit_service?id='.$d['service_id'].'" class="btn text-dark mr-1">
                                    <i class="fas fa-edit"></i>
                                </a>
                                </button>'.$banBtn.'<button onClick="banStatus('.$d['service_id'].',2)" class="btn mr-1">
                                    <i class="fas fa-remove"></i>
                                </button>
                            </td>
                        </tr>';
            }
        }

        $html.='</tbody>
        </table>';

        return response()->json([
            'html' => $html
        ]);
    }
}
