<?php

namespace App\Http\Controllers\Data;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class News extends Controller
{
    public function index()
    {
        $html = '<div class=" col-lg-12 row mb-5">
                    <a href="add_news" class="btn btn-primary mr-2"><i class="fas fa-plus"></i> Add News</a>
                    <button onClick="get_news()" class="btn btn-danger"><i class="fas fa-refresh"></i></button>
                </div>
        <table id="data" class="table table-borderless table-striped table-earning">
            <thead>
                <tr>
                    <th></th>
                    <th>Title</th>
                    <th>Image</th>
                    <th>Text</th>
                    <th>URL</th>
                    <th>Meta Description</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>';

        $get_news = std_get([
            'table_name' => 'news',
            'where' => [
                [
                    'field_name' => 'news_status',
                    'operator' => '!=',
                    'value' => 2
                ]
            ],
            'order_by' => [
                [
                    'field' => 'created_by_timestamp',
                    'type' => 'DESC'
                ]
            ]
        ]);

        if(count($get_news) > 0)
        {
            foreach($get_news as $d)
            {
                $status = $d['news_status'];
                $title = "'".$d['news_title']."'";

                if($status == 1)
                {
                    $status = '<i class="badge badge-success">Shown<i/>';
                    $banBtn = '<button onClick="statusChange('.$d['news_id'].','.$title.',0)" class="btn mr-1">
                                    <i class="fas fa-eye-slash"></i>
                                </button>';
                } elseif($status == 0)
                {
                    $status = '<i class="badge badge-danger">Hidden<i/>';
                    $banBtn = '<button onClick="statusChange('.$d['news_id'].','.$title.',1)" class="btn mr-1">
                                    <i class="fas fa-eye"></i>
                                </button>';
                }
                $html .= '<tr>
                            <td></td>
                            <td>'.$d['news_title'].'</td>
                            <td>
                                <img src="./storage/uploaded/news_image/'.$d['news_image'].'" style="width:100px; object-fit:cover;" alt="'.$d['news_image_alt'].'" />
                            </td>
                            <td>'.$d['news_text'].'</td>
                            <td>'.$d['news_url'].'</td>
                            <td>'.$d['news_meta_description'].'</td>
                            <td>'.$status.'</td>
                            <td>
                                <a href="edit_news?id='.$d['news_id'].'" class="btn text-dark mr-1">
                                    <i class="fas fa-edit"></i>
                                </a>'.$banBtn.'<button onClick="statusChange('.$d['news_id'].','.$title.',2)" class="btn mr-1">
                                    <i class="fas fa-remove"></i>
                                </button>
                            </td>
                        </tr>';
            }
        }

        $html.='</tbody>
        </table>';

        return response()->json([
            'html' => $html
        ]);
    }
}
