<?php

namespace App\Http\Controllers\Data;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class Loker extends Controller
{
    public function index()
    {
        $html = '<div class=" col-lg-12 row mb-5">
                    <a href="add_loker" class="btn btn-primary mr-2"><i class="fas fa-plus"></i> Add loker</a>
                    <button onClick="get_loker()" class="btn btn-danger"><i class="fas fa-refresh"></i></button>
                </div>
        <table id="data" class="table table-borderless table-striped table-earning">
            <thead>
                <tr>
                    <th></th>
                    <th>Title</th>
                    <th>Image</th>
                    <th>Text</th>
                    <th>URL</th>
                    <th>Meta Description</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>';

        $get_loker = std_get([
            'table_name' => 'loker',
            'where' => [
                [
                    'field_name' => 'loker_status',
                    'operator' => '!=',
                    'value' => 2
                ]
            ],
            'order_by' => [
                [
                    'field' => 'created_by_timestamp',
                    'type' => 'DESC'
                ]
            ]
        ]);

        if(count($get_loker) > 0)
        {
            foreach($get_loker as $d)
            {
                $status = $d['loker_status'];
                $title = "'".$d['loker_title']."'";

                if($status == 1)
                {
                    $status = '<i class="badge badge-success">Shown<i/>';
                    $banBtn = '<button onClick="statusChange('.$d['loker_id'].','.$title.',0)" class="btn mr-1">
                                    <i class="fas fa-eye-slash"></i>
                                </button>';
                } elseif($status == 0)
                {
                    $status = '<i class="badge badge-danger">Hidden<i/>';
                    $banBtn = '<button onClick="statusChange('.$d['loker_id'].','.$title.',1)" class="btn mr-1">
                                    <i class="fas fa-eye"></i>
                                </button>';
                }
                $html .= '<tr>
                            <td></td>
                            <td>'.$d['loker_title'].'</td>
                            <td>
                                <img src="./storage/uploaded/loker_image/'.$d['loker_image'].'" style="width:100px; object-fit:cover;" alt="'.$d['loker_image_alt'].'" />
                            </td>
                            <td>'.$d['loker_text'].'</td>
                            <td>'.$d['loker_url'].'</td>
                            <td>'.$d['loker_meta_description'].'</td>
                            <td>'.$status.'</td>
                            <td>
                                <a href="edit_loker?id='.$d['loker_id'].'" class="btn text-dark mr-1">
                                    <i class="fas fa-edit"></i>
                                </a>'.$banBtn.'<button onClick="statusChange('.$d['loker_id'].','.$title.',2)" class="btn mr-1">
                                    <i class="fas fa-remove"></i>
                                </button>
                            </td>
                        </tr>';
            }
        }

        $html.='</tbody>
        </table>';

        return response()->json([
            'html' => $html
        ]);
    }
}
