<?php

namespace App\Http\Controllers\Data;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class Clients extends Controller
{
    public function index()
    {
        $link = "'client/add'";
        $html = '<div class=" col-lg-12 row mb-5">
                    <button onClick="showForm('.$link.')" class="btn btn-primary mr-2"><i class="fas fa-plus"></i> Add Client</button>
                    <button onClick="get_clients()" class="btn btn-danger"><i class="fas fa-refresh"></i></button>
                </div>
        <table id="data" class="table table-borderless table-striped table-earning">
            <thead>
                <tr>
                    <th></th>
                    <th>Image</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>';

        $get_client = std_get([
            'table_name' => 'client',
            'order_by' => [
                [
                    'field' => 'created_by_timestamp',
                    'type' => 'DESC'
                ]
            ],
            'where' => [
                [
                    'field_name' => 'client_status',
                    'operator' => '!=',
                    'value' => 2
                ],

            ]
        ]);

        if(count($get_client) > 0)
        {
            foreach($get_client as $d)
            {
                $status = $d['client_status'];

                if($status == 1)
                {
                    $status = '<i class="badge badge-success">Active<i/>';
                    $banBtn = '<button onClick="banStatus('.$d['client_id'].',0)" class="btn mr-1">
                                    <i class="fas fa-ban"></i>
                                </button>';
                } elseif($status == 0)
                {
                    $status = '<i class="badge badge-danger">Hidden<i/>';
                    $banBtn = '<button onClick="banStatus('.$d['client_id'].',1)" class="btn mr-1">
                                    <i class="fas fa-check"></i>
                                </button>';
                }

                $link_edit = "'client/edit/?id=".$d['client_id']."'";
                $html .= '<tr>
                            <td></td>
                            <td>
                                <img src="./storage/uploaded/client_image/'.$d['client_image'].'" style="width: 100px; object-fot: contain;" />
                            </td>
                            <td>'.$status.'</td>
                            <td>
                                <button onClick="showForm('.$link_edit.')" class="btn mr-1">
                                    <i class="fas fa-edit"></i>
                                </button>'.$banBtn.'<button onClick="banStatus('.$d['client_id'].',2)" class="btn mr-1">
                                    <i class="fas fa-remove"></i>
                                </button>
                            </td>
                        </tr>';
            }
        }

        $html.='</tbody>
        </table>';

        return response()->json([
            'html' => $html
        ]);
    }
}
