<?php

namespace App\Http\Controllers\Data;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class Admin extends Controller
{
    public function index()
    {
        $link = "'admin/add'";
        $html = '<div class=" col-lg-12 row mb-5">
                    <button onClick="showForm('.$link.')" class="btn btn-primary mr-2"><i class="fas fa-plus"></i> Add Admin</button>
                    <button onClick="get_admin()" class="btn btn-danger"><i class="fas fa-refresh"></i></button>
                </div>
        <table id="data" class="table table-borderless table-striped table-earning">
            <thead>
                <tr>
                    <th></th>
                    <th>Username</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>';

        $get_admin = std_get([
            'table_name' => 'admin',
            'order_by' => [
                [
                    'field' => 'created_by_timestamp',
                    'type' => 'DESC'
                ]
            ],
            'where' => [
                [
                    'field_name' => 'admin_status',
                    'operator' => '!=',
                    'value' => 2
                ],
                [
                    'field_name' => 'admin_username',
                    'operator' => '!=',
                    'value' => session('username')
                ]
            ]
        ]);

        if(count($get_admin) > 0)
        {
            foreach($get_admin as $d)
            {
                $status = $d['admin_status'];
                $username = "'".$d['admin_username']."'";

                if($status == 1)
                {
                    $status = '<i class="badge badge-success">Active<i/>';
                    $banBtn = '<button onClick="banStatus('.$d['admin_id'].','.$username.',0)" class="btn mr-1">
                                    <i class="fas fa-ban"></i>
                                </button>';
                } elseif($status == 0)
                {
                    $status = '<i class="badge badge-danger">Banned<i/>';
                    $banBtn = '<button onClick="banStatus('.$d['admin_id'].','.$username.',1)" class="btn mr-1">
                                    <i class="fas fa-check"></i>
                                </button>';
                }

                $link_edit = "'admin/edit/?id=".$d['admin_id']."'";
                $html .= '<tr>
                            <td></td>
                            <td>'.$d['admin_username'].'</td>
                            <td>'.$status.'</td>
                            <td>
                                <button onClick="showForm('.$link_edit.')" class="btn mr-1">
                                    <i class="fas fa-edit"></i>
                                </button>'.$banBtn.'<button onClick="banStatus('.$d['admin_id'].','.$username.',2)" class="btn mr-1">
                                    <i class="fas fa-remove"></i>
                                </button>
                            </td>
                        </tr>';
            }
        }

        $html.='</tbody>
        </table>';

        return response()->json([
            'html' => $html
        ]);
    }
}
