<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class Auth extends Controller
{
    public function index()
    {
        if(session('is_login') == 1)
        {
            return redirect('dashboard');
        }

        return view('login');
    }

    public function login(Request $req)
    {
        $validate = Validator::make($req->all(),[
            'username' => 'required|max:255',
            'password' => 'required|max:255'
        ]);

        $validate->setAttributeNames([
            'username' => 'Username',
            'password' => 'Password'
        ]);

        if($validate->fails())
        {
            return response()->json([
                'status' => 'warning',
                'warning' => 'Invalid',
                'message' => $validate->errors()->all()
            ]);
        }

        $check_username = std_get([
            'table_name' => 'admin',
            'first_row' => true,
            'where' => [
                [
                    'field_name' => 'admin_username',
                    'operator' => '=',
                    'value' => $req->username
                ]
            ]
        ]);

        if($check_username == NULL)
        {
            return response()->json([
                'status' => 'warning',
                'warning' => 'User not found',
                'message' => 'Account not found'
            ]);
        }

        $check_login = std_get([
            'table_name' => 'admin',
            'first_row' => true,
            'where' => [
                [
                    'field_name' => 'admin_username',
                    'operator' => '=',
                    'value' => $req->username
                ],
                [
                    'field_name' => 'admin_password',
                    'operator' => '=',
                    'value' => md5($req->password)
                ]
            ]
        ]);

        if($check_login == NULL)
        {
            return response()->json([
                'status' => 'warning',
                'warning' => 'Wrond password',
                'message' => 'Password not matched'
            ]);
        }

        session(['id' => $check_login['admin_id']]);
        session(['username' => $check_login['admin_username']]);
        session(['is_login' => 1]);

        return response()->json([
            'status' => 'success'
        ]);
    }

    public function logout()
    {
        session()->forget(['id','username','is_login']);

        return redirect('');
    }
}
